//------------------------------------------------------------------------------
// Modulo de reconhecimento da digital
//------------------------------------------------------------------------------
unit UnRecDig;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, jpeg, unCompBio;

type
  TfrmRecDig = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    pnBot: TPanel;
    btRet: TBitBtn;
    Panel3: TPanel;
    imgFot: TImage;
    GroupBox4: TGroupBox;
    Label9: TLabel;
    lblMot01: TLabel;
    lblMot01c: TLabel;
    GroupBox3: TGroupBox;
    lblCodAss01: TLabel;
    lblNmAss01: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Panel4: TPanel;
    imgDig: TImage;
    GroupBox1: TGroupBox;
    Label8: TLabel;
    mmLog: TMemo;
    pnSts: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btRetClick(Sender: TObject);
  private
    prvBio: TCompBio;
    procedure rPesquisa(var pStr: string);
  public
    { Public declarations }
  end;

var
  frmRecDig: TfrmRecDig;

implementation

uses Unit1;


{$R *.dfm}
//------------------------------------------------------------------------------
// Rotina que ir pesquisar a digital
//------------------------------------------------------------------------------
procedure TfrmRecDig.rPesquisa(var pStr: string);
var
  lvLog: string;
//------------------------------------------------------------------------------
    function fPesquisa_digitalBase(): boolean;
    var
      lvStr, lvNm: string;
      lvSc: integer;
      lvIdx: integer;
      lvLst: TStringList;
    begin
        Result := false;
        lvLst := TStringList.Create();
        lvLst.Text := form1.http.Get(cteURLGet);
        for lvIdx := 0 to lvLst.Count - 1 do
            begin
            lvStr := lvLst[lvIdx];
            prvBio.fIdentifica(lvStr, lvSc);
            Result := (lvSc >= 90);
            if (Result = true) then
               begin
               break;
               end;
            end;
        FreeAndNil(lvLst);

{        form1.qry.SQL.Text := 'SELECT ds_digital,nm_foto FROM digital';
        form1.qry.Open;
        while not form1.qry.Eof do
            begin
            lvStr := form1.qry.FieldByName('ds_digital').AsString;
            lvNm  := form1.qry.FieldByName('nm_foto').AsString;
            prvBio.fIdentifica(lvStr, lvSc);
            Result := (lvSc >= 90);
            if (Result = true) then
               begin
               lvStr := ExtractFilePath(ParamStr(0)) + lvNm;
               if (FileExists(lvStr)) then
                  imgDig.Picture.Bitmap.LoadFromFile(lvStr);
               break;
               end;
            form1.qry.Next();
            end;
        form1.qry.Close();
        }
    end;
//------------------------------------------------------------------------------
    function fPesquisa_digital(): boolean;
    var
      lvSR: TSearchRec;
      lvInt: integer;
      lvDir, lvStr: string;
      lvLst: TStringList;
      lvSc: integer;
    begin
        lvDir  := ExtractFilePath(ParamStr(0));
        lvInt  := FindFirst(lvDir + '*.dig', faAnyFile, lvSR);
        lvLst  := TStringList.Create();
        Result := false;
        while lvInt = 0 do
           begin
           if (lvSR.Attr and faDirectory) <> faDirectory then
              begin
              lvLst.LoadFromFile(lvDir + lvSR.Name);
              prvBio.fIdentifica(lvLst.Text, lvSc);
              Result := (lvSc >= 90);
              if (Result = true) then
                 begin
                 lvStr := lvDir + Copy(lvSR.Name, 1, Length(lvSR.Name) -4) + '.bmp';
                 imgDig.Picture.Bitmap.LoadFromFile(lvStr);
                 break;
                 end;
              end;
           lvInt := FindNext(lvSR);
           end;
        SysUtils.FindClose(lvSR);
        FreeAndNil(lvLst);
    end;
//------------------------------------------------------------------------------
begin
    lvLog := FormatDateTime('dd/MM/yyyy', Date()) + ' ' +
         FormatDateTime('HH:mm:ss', Time()) + ' - ';
    if (fPesquisa_digitalBase()) then
       begin
       // coloque aqui outras informacoes
       mmLog.Lines.Add(lvLog + 'Digital identificada...')
       end
    else
       begin
       mmLog.Lines.Add(lvLog + 'Digital no identificada...');
       imgDig.Picture := nil;
       end;
end;
//------------------------------------------------------------------------------
// Sair da tela
//------------------------------------------------------------------------------
procedure TfrmRecDig.btRetClick(Sender: TObject);
begin
    Close();
end;
//------------------------------------------------------------------------------
// Quando o formulario for criado
//------------------------------------------------------------------------------
procedure TfrmRecDig.FormCreate(Sender: TObject);
begin
    lblCodAss01.Caption := '';
    lblNmAss01.Caption  := '';
    lblMot01.Caption    := '';
// se a DLL estiver em outra pasta favor setar
//    plPstGri            := '';
//
    prvBio         := TCompBio.Create(Self);
    prvBio.OnEvt   := rPesquisa;
    prvBio.plPn01  := pnSts;
    prvBio.fInitGrFinger();
end;
//------------------------------------------------------------------------------
// Quando o formulario for destruido
//------------------------------------------------------------------------------
procedure TfrmRecDig.FormDestroy(Sender: TObject);
begin
    prvBio.rFinalizeGrFinger();
    FreeAndNil(prvBio);
end;

end.
