unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdHTTP, zlib;

const
  cteURLPost = 'http://localhost/folhaPonto/biometria/digital.php';
  cteURLGet  = 'http://localhost/folhaPonto/biometria/digitalPost.php';

//  cteURLPost = 'http://rssistemas_sp.hyperphp.com/digitalPost.php';
//  cteURLGet = 'http://rssistemas_sp.hyperphp.com/digital.php';
  //'http://localhost:3569/digitalPost.php'
  //'http://localhost:3569/digital.php'
  

type
  TForm1 = class(TForm)
    imgDig: TImage;
    http: TIdHTTP;
    Panel1: TPanel;
    btCapt: TButton;
    btSave: TButton;
    btRec: TButton;
    Panel2: TPanel;
    mmLog: TMemo;
    Button1: TButton;
    procedure btCaptClick(Sender: TObject);
    procedure btRecClick(Sender: TObject);
    procedure btSaveClick(Sender: TObject);
    procedure httpStatus(ASender: TObject; const AStatus: TIdStatus;
      const AStatusText: string);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    prvStr: string;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses UnCaptDig, UnRecDig, unCompBio;

{$R *.dfm}


function CompressString(const S: string) : string;
var
  InputStream: TCompressionStream;
  OutputStream: TMemoryStream;
  Size: Integer;
begin
  OutputStream := TMemoryStream.Create;

  try
    InputStream := TCompressionStream.Create(clMax, OutputStream);
    try
      Size := Length(S);
      InputStream.Write(Size, SizeOf(Size));
      InputStream.Write(S[1], Size)
    finally
      InputStream.Free
    end;

    SetLength(Result, OutputStream.Size);
    OutputStream.Seek(0, soFromBeginning);
    OutputStream.Read(Result[1], Length(Result))

  finally
    OutputStream.Free
  end
end;

(*
 * DecompressString() usage:
 *
 * DataString := DecompressString(CompressedString);
 *)
function DecompressString(const S: string) : string;
var
  InputStream: TMemoryStream;
  OutputStream: TDecompressionStream;
  Size: Integer;
begin
  InputStream := TMemoryStream.Create;

  try
    InputStream.Write(S[1], Length(S));
    InputStream.Seek(0, soFromBeginning);

    OutputStream := TDecompressionStream.Create(InputStream);
    try
      OutputStream.Read(Size, SizeOf(Size));
      SetLength(Result, Size);
      OutputStream.Read(Result[1], Size)

    finally
      OutputStream.Free
    end

  finally
    InputStream.Free
  end
end;

procedure TForm1.btCaptClick(Sender: TObject);
begin
    mmLog.Lines.Add('Capturar Digital');
    plDig_bmp  := TBitmap.Create();
    frmDigital := TfrmDigital.Create(Self);
    if (frmDigital.ShowModal() = mrOK) then
       begin
       prvStr :=  plDig_hex;
       imgDig.Picture.Bitmap.Assign(plDig_bmp);
       btSave.Enabled := true;
       end;
    freeandnil(frmDigital);
    freeandnil(plDig_bmp);
end;

procedure TForm1.btRecClick(Sender: TObject);
begin
    mmLog.Lines.Add('Reconhecer Digital');
    frmRecDig := TfrmRecDig.Create(Self);
    frmRecDig.ShowModal;
    freeandnil(frmRecDig);
end;

procedure TForm1.btSaveClick(Sender: TObject);
var
  lvNm: string;
  lvTxt: TextFile;
  lvPar: TStringList;
  lvST : TStringStream;

begin
    if (Application.MessageBox('Deseja salvar a digital ?', '', MB_YESNO) =
        IDYES) then
       begin
       lvNm  := FormatDateTime('yyyyMMdd', Date()) + '.';
       lvNm  := lvNm + FormatDateTime('hhmmss', Time());
       lvPar := TStringList.Create();
       lvST  := TStringStream.Create('');
       http.Request.Clear();
       http.Response.Clear();
       lvPar.Add('pDigital=' + prvStr);
       http.Post(cteURLPost, lvPar, lvST);
       lvST.Position := 0;
       showmessage(lvST.DataString);
       freeandnil(lvPar);
       freeandnil(lvST);
       end;
end;



procedure TForm1.Button1Click(Sender: TObject);
begin
    Close();
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
// Precisa colocar isso, pois o http eh um RuWindows
    http.Request.UserAgent := 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)';
    mmLog.Lines.Add('Bem vindo ao controle de biometria OnLine v.1.01');
end;

procedure TForm1.httpStatus(ASender: TObject; const AStatus: TIdStatus;
  const AStatusText: string);
begin
    mmLog.Lines.Add(AStatusText);
end;

end.
